/************************************************************************\
\************************************************************************/

#include <stdio.h>
#include "objects.h"
#include "NewtonScript.h"
#include "applefile.h"


typedef struct ParseInfo {
	OSType		fType;
	OSType		fCreator;
	ULong		dataLen;
	ULong		rsrcLen;
	char		*dataP;
	char		fName[255];
} ParseInfo;


static long _hqxDecode ( void * srcUnicodeP, ParseInfo *info );


extern "C" Ref HQXDecode ( RefArg rcvr, RefArg srcBinObj, RefArg destBinObj, RefArg infoFrame )
{
	if ( !IsBinary(srcBinObj) )
		ThrowBadTypeWithFrameData ( -48408, srcBinObj );	// expected a binary object

	if ( !IsBinary(destBinObj) )
		ThrowBadTypeWithFrameData ( -48408, destBinObj );	// expected a binary object

	if ( !IsFrame(infoFrame) )
		ThrowBadTypeWithFrameData ( -48400, infoFrame );	// expected a frame

	long		resultLength;
	ParseInfo	parseInfo;

	parseInfo.dataP = nil;

	WITH_LOCKED_BINARY ( srcBinObj, srcP )

		resultLength = _hqxDecode ( srcP, &parseInfo );

	END_WITH_LOCKED_BINARY ( srcBinObj )

	RefVar	kindSymbol = SYM ( kind );

	if ( resultLength < 1 )
	{
		SetVariable ( infoFrame, kindSymbol, SYM ( unknown ) );

		SetVariable ( infoFrame, SYM ( error ), MakeInt ( resultLength ) );

		parseInfo.dataLen = 0;		// tell caller to set length to 0!!!
	}

	else
	{
		if ( parseInfo.dataP )
		{
			// make sure the destBin object is large enough
			SetLength ( destBinObj, resultLength );

			// copy the binary data to the dest object
			WITH_LOCKED_BINARY ( destBinObj, destP )
				BlockMove ( parseInfo.dataP, destP, resultLength );
			END_WITH_LOCKED_BINARY ( destBinObj )

			// delete the system heap object
			DisposePtr ( parseInfo.dataP );
		}

		switch ( parseInfo.fType )
		{
		case 'pkg ':
			SetVariable ( infoFrame, kindSymbol, SYM ( package ) );
			break;

		case 'newt':
			if ( parseInfo.fCreator == 'rot' )
				SetVariable ( infoFrame, kindSymbol, SYM ( enrouteFrame ) );
			break;

		case 'TEXT':
			SetVariable ( infoFrame, kindSymbol, SYM ( text ) );
			break;

		default:
			SetVariable ( infoFrame, kindSymbol, SYM ( unknown ) );
			break;
		}

		UByte	*cP;
		UniChar	uFType[5];
		UniChar	uFCrea[5];

		cP = (UByte *)&parseInfo.fType;
		for ( short i = 0; i < 4; i++ )
		{
			uFType[i] = cP[i];
		}
		uFType[4] = 0;
		SetVariable ( infoFrame, SYM ( fType ), MakeString ( uFType ) );

		cP = (UByte *)&parseInfo.fCreator;
		for ( short i = 0; i < 4; i++ )
		{
			uFCrea[i] = cP[i];
		}
		uFCrea[4] = 0;
		SetVariable ( infoFrame, SYM ( fCreator ), MakeString ( uFCrea ) );

		SetVariable ( infoFrame, SYM ( fName ), MakeString ( parseInfo.fName ) );
	}

	return MakeInt ( parseInfo.dataLen );
}


static long _CalcCRC ( char *d, long start, long len );


#define RUNCHAR 0x90

#define DONE 0x7F
#define SKIP 0x7E
#define FAIL 0x7D
#define DIE  0x7C

const char lookup[256] = {
/*       ^@    ^A    ^B    ^C    ^D    ^E    ^F    ^G   */
/* 0*/	 DIE, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
/*       \b    \t    \n    ^K    ^L    \r    ^N    ^O   */
/* 1*/	FAIL, FAIL, SKIP, FAIL, FAIL, SKIP, FAIL, FAIL,
/*       ^P    ^Q    ^R    ^S    ^T    ^U    ^V    ^W   */
/* 2*/	FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
/*       ^X    ^Y    ^Z    ^[    ^\    ^]    ^^    ^_   */
/* 3*/	FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
/*              !     "     #     $     %     &     '   */
/* 4*/	FAIL, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
/*        (     )     *     +     ,     -     .     /   */
/* 5*/	0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, FAIL, FAIL,
/*        0     1     2     3     4     5     6     7   */
/* 6*/	0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, FAIL,
/*        8     9     :     ;     <     =     >     ?   */
/* 7*/	0x14, 0x15, DONE, FAIL, FAIL, FAIL, FAIL, FAIL,
/*        @     A     B     C     D     E     F     G   */
/* 8*/	0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D,
/*        H     I     J     K     L     M     N     O   */
/* 9*/	0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24, FAIL,
/*        P     Q     R     S     T     U     V     W   */
/*10*/	0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, FAIL,
/*        X     Y     Z     [     \     ]     ^     _   */
/*11*/	0x2C, 0x2D, 0x2E, 0x2F, FAIL, FAIL, FAIL, FAIL,
/*        `     a     b     c     d     e     f     g   */
/*12*/	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, FAIL,
/*        h     i     j     k     l     m     n     o   */
/*13*/	0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, FAIL, FAIL,
/*        p     q     r     s     t     u     v     w   */
/*14*/	0x3D, 0x3E, 0x3F, FAIL, FAIL, FAIL, FAIL, FAIL,
/*        x     y     z     {     |     }     ~    ^?   */
/*15*/	FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
/*16*/	FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
		FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL,
};

#define S_HDRSTART	0
#define S_HEADER	1
#define S_DATAFORK	2
#define S_DATAC1	3
#define S_DATAC2	4


static long _hqxDecode ( void * srcUnicodeP, ParseInfo *info )
{
	short	* p       = (short *)srcUnicodeP;
	char	* resultP;

	char	* tempBin = nil;

	unsigned char hdrBuff [ 256 + 22 ];		// really the maximum required

	char	fName[255];
	long	fNmLen;

	resultP = (char *)hdrBuff;

	long	theCRC;
	long	ourCRC;

	long	uneven_lines = 1;

	long	b6;
	long	b8;
	long	data;
	long	lastc = 0;
	long	buffSize = 255;
	long	buffCtr = 0;
	char	state68 = 0;
	char	run = 0;
	char	first = 1;

	long	ostate = S_HDRSTART;	//S_HEADER;

	while ( ! (*p == 0x0D || *p == 0) )		// scan for initial <CR>
		p++;

	while ( ! (*p == 0x3A || *p == 0) )		// scan for initial ':'
		p++;

	if ( *p == 0 )	// end of text with no "end" marker
		return 0;

	long	stop = 0;

	while ( ! stop )
	{
		do
		{
			if ( ( b6 = lookup[*p & 0xff] ) >= 64 )
			{
				switch (b6)
				{
					case DONE:
						first = !first;
						if ( first )
						{
							goto done;
						}
					case SKIP:
						break;
					case DIE:
						stop = 1;
						goto done;
					default:
						break;
				}
			}
			else
			{
				// Pack 6 bits to 8 bits
				switch ( state68++ )
				{
					case 0:
						b8 = b6 << 2;
						continue;		// No data byte

					case 1:
						data = b8 | (b6 >> 4);
						b8 = (b6 & 0xF) << 4;
						break;

					case 2:
						data = b8 | (b6>>2);
						b8 = (b6&0x3) << 6;
						break;

					case 3:
						data = b8 | b6;
						state68 = 0;
						break;
				}

				if ( !run )
				{
					if ( data == RUNCHAR )
					{
						run = 1;
						continue;
					}
					else
					{
						*resultP++ = lastc = data;
						++buffCtr;
					}
				}
				else
				{
					if ( data == 0 )
					{
						*resultP++ = lastc = RUNCHAR;
						++buffCtr;
					}
					else
					{
						while ( --data > 0 )
						{
							*resultP++ = lastc;
							++buffCtr;
						}
					}
					run = 0;
				}

				switch ( ostate )
				{
					case S_HDRSTART:
						ostate   = S_HEADER;
						fNmLen   = lastc;
						buffSize = lastc + 22;
						break;
					case S_HEADER:
						ostate = S_HEADER;
						if ( buffCtr >= buffSize )
						{
							char	*hdrP = (char *)hdrBuff;
							++hdrP;
							int i;
							for ( i = 0; i <= fNmLen; i++ )
							{
								info->fName[i] = *hdrP++;
							}

							long	aTemp;
							aTemp = *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							info->fType = aTemp;

							aTemp = *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							info->fCreator = aTemp;

							hdrP += 2;

							aTemp = *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							info->dataLen = aTemp;

							aTemp = *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							aTemp <<= 8;
							aTemp |= *hdrP++;
							info->rsrcLen = aTemp;

							theCRC = ( hdrP[0] << 8) + ( hdrP[1] );
							hdrP[0] = 0;
							hdrP[1] = 0;
							ourCRC = _CalcCRC ( (char *)hdrBuff, 0, buffSize-2 );
							if ( ! (theCRC == ourCRC) )
							{
								return -1;
							}

							buffSize = info->dataLen;
							buffCtr  = 0;		// now counts data
							ostate   = S_DATAFORK;
							tempBin = (char *)NewPtrClear ( buffSize + 2 );		// allocate a temp
							if ( ! ( MemError() == 0 ) )
							{
								return -2;
							}
							resultP  = tempBin;	// WAS: (char *)destBinP;
						}
						break;
					case S_DATAFORK:
						if ( buffCtr >= buffSize )
						{
							//BlockMove ( tempBin, destBinP, buffSize );
							ostate = S_DATAC1;
						}
						break;
					case S_DATAC1:
						theCRC = ( lastc << 8 );
						--resultP;
						*resultP++ = 0;
						ostate   = S_DATAC2;
						break;
					case S_DATAC2:
						theCRC += lastc;
						--resultP;
						*resultP-- = 0;
						ourCRC = _CalcCRC ( (char *)tempBin, 0, buffSize );
						if ( ! (theCRC == ourCRC) )
						{
							if ( tempBin )
								DisposePtr ( tempBin );
							return -3;
						}
						goto done;
						break;
				}
			}
		}
		while ( ++p && !stop );

		if ( !stop )
		{
			if ( *p == 0 )
			{
				break;
			}
		}
	}

done:
	if ( tempBin )
		info->dataP = tempBin;

	return info->dataLen;
}


static long _CalcCRC ( char *d, long start, long len )
{
	long crcT[] = {
		0,     4129,  8258,  12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935,
		4657,  528,   12915, 8786,  21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334,
		9314,  13379, 1056,  5121,  25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669,
		13907, 9842,  5649,  1584,  30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132,
		18628, 22757, 26758, 30887, 2112,  6241,  10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403,
		23285, 19156, 31415, 27286, 6769,  2640,  14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802,
		27814, 31879, 19684, 23749, 11298, 15363, 3168,  7233,  60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265,
		32407, 28342, 24277, 20212, 15891, 11826, 7761,  3696,  65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728,
		37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224,  161,   12482, 8419,  20484, 16421, 28742, 24679,
		33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689,   4752,  8947,  13010, 16949, 21012, 25207, 29270,
		46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411,  5280,  1153,  29798, 25671, 21540, 17413,
		42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939,  14066, 1681,  5808,  26199, 30326, 17941, 22068,
		55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336,  2273,  14466, 10403,
		52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801,  6864,  10931, 14994,
		64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392,  3265,
		61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793,  7920,
		};

	long	stop = (start + len);

	long	crc = 0;	// BinHex seed

	for ( long i = start; i < stop; i++ )
	{
		crc = 0xFFFF &
			( (crc << 8) ^ crcT[ ((crc >> 8) ^ d[i]) & 0xFF] );
	}
	return crc;
}


/************************************************************

void BlockMove ( const void * srcPtr, void * destPtr, Size byteCount );
void			DisposPtr(Ptr p);
Size			GetPtrSize(Ptr p);
Ptr				NewPtr(Size size);
Ptr				NewPtrClear(Size byteCount);
Heap			PtrToHeap(Ptr);
Ptr				ReallocPtr(Ptr, Size);			// like realloc


Size			TotalFreeInHeap(Heap DEFAULT_NIL);
Size			LargestFreeInHeap(Heap DEFAULT_NIL);
unsigned long	CountFreeBlocks(Heap DEFAULT_NIL);
Size			TotalUsedInHeap(Heap DEFAULT_NIL);
Size			MaxHeapSize(Heap DEFAULT_NIL);

//____________________________________________________________________
// Frame & Slot Functions

extern	Ref		AllocateFrame(void);
extern	Boolean	FrameHasPath(RefArg obj, RefArg thePath);
extern	Boolean	FrameHasSlot(RefArg obj, RefArg slot);
extern	Ref		GetFramePath(RefArg obj, RefArg thePath);
extern	Ref		GetFrameSlot(RefArg obj, RefArg slot);
extern	long	Length ( RefArg obj );		// Length in bytes or slots
extern	void	MapSlots(RefArg obj, MapSlotsFunction func, ULong anything);

extern	void	RemoveSlot(RefArg frame, RefArg tag);
extern	void	SetFramePath(RefArg obj, RefArg thePath, RefArg value);		
extern	void	SetFrameSlot(RefArg obj, RefArg slot, RefArg value);
extern	void	SetLength(RefArg obj, long length);

extern	Ref		MakeString(const char* str);

*/
